/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.rendering;

import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.client.display.Display;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;

public class DisplayRenderer
implements class_827<DisplayTile> {
    private final class_5614.class_5615 context;
    long loggerTime = System.currentTimeMillis();

    public DisplayRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public boolean shouldRenderOffScreen(DisplayTile tile) {
        return tile.data.getWidth() > 16.0f || tile.data.getHeight() > 16.0f;
    }

    public boolean shouldRender(DisplayTile tile, @NotNull class_243 cameraPos) {
        class_2338 tilePos = tile.method_11016().method_10079(tile.getDirection(), (int)tile.data.projectionDistance);
        return class_243.method_24953((class_2382)tilePos).method_24802((class_2374)cameraPos, (double)tile.data.renderDistance);
    }

    public void render(DisplayTile tile, float partialTicks, class_4587 pose, class_4597 bufferSource, int packedLight, int packedOverlay) {
        int b;
        Display display = tile.activeDisplay();
        if (display == null || !DisplaysConfig.keepsRendering()) {
            return;
        }
        display.preRender();
        class_2350 direction = tile.getDirection();
        AlignedBox box = tile.getRenderBox();
        boolean invertedFace = tile.caps.invertedFace(tile);
        BoxFace boxFace = BoxFace.get((Facing)Facing.get((class_2350)(invertedFace ? direction.method_10153() : direction)));
        Facing facing = boxFace.facing;
        packedLight = 0xF000F0;
        boolean front = !tile.caps.projects() || tile.data.renderBothSides;
        boolean back = tile.caps.projects() || tile.data.renderBothSides;
        boolean flipX = tile.caps.projects() != tile.data.flipX;
        boolean flipY = tile.data.flipY;
        int g = b = tile.data.brightness;
        int r = b;
        int a = tile.data.alpha;
        pose.method_22903();
        pose.method_22904(0.5, 0.5, 0.5);
        pose.method_22907(facing.rotation().rotation((float)Math.toRadians(-tile.data.rotation)));
        pose.method_22904(-0.5, -0.5, -0.5);
        if (tile.caps.growMax(tile, facing, invertedFace)) {
            box.setMax(facing.axis, box.getMax(facing.axis) + tile.caps.growSize());
        } else {
            box.setMin(facing.axis, box.getMin(facing.axis) - tile.caps.growSize());
        }
        if (display.isLoading()) {
            this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
        } else if (display.canRender()) {
            class_2960 tex = display.getTextureId();
            if (tex != null) {
                this.vertex(pose, bufferSource, box, boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, tex);
            }
            if (display.isBuffering()) {
                this.vertex(pose, bufferSource, this.getLoadingBox(tile, box, facing), boxFace, facing, packedLight, packedOverlay, front, back, flipX, flipY, r, g, b, a, WaterFrames.LOADING_ANIMATION);
            }
        }
        pose.method_22909();
    }

    public void vertex(class_4587 pose, class_4597 source, AlignedBox box, BoxFace boxface, Facing facing, int packedLight, int packedOverlay, boolean front, boolean back, boolean flipX, boolean flipY, int r, int g, int b, int a, class_2960 texture) {
        BoxCorner corner;
        int i;
        class_4588 builder = source.getBuffer(class_1921.method_23689((class_2960)texture));
        if (front) {
            for (i = 0; i < boxface.corners.length; ++i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
        if (back) {
            for (i = boxface.corners.length - 1; i >= 0; --i) {
                corner = boxface.corners[i];
                this.vertex(pose, builder, box, boxface, corner, facing, packedLight, packedOverlay, flipX, flipY, r, g, b, a);
            }
        }
    }

    public void vertex(class_4587 pose, class_4588 builder, AlignedBox box, BoxFace boxface, BoxCorner corner, Facing facing, int packedLight, int packedOverlay, boolean flipX, boolean flipY, int r, int g, int b, int a) {
        class_2382 normal = facing.normal;
        builder.method_22918(pose.method_23760().method_23761(), box.get(corner.x), box.get(corner.y), box.get(corner.z)).method_1336(r, g, b, a).method_22913(corner.isFacing(boxface.getTexU()) != flipX ? 1.0f : 0.0f, corner.isFacing(boxface.getTexV()) != flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(pose.method_23760().method_23762(), (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).method_1344();
    }

    public AlignedBox getLoadingBox(DisplayTile tile, AlignedBox parent, Facing facing) {
        float height;
        AlignedBox box = new AlignedBox(parent);
        Axis one = facing.one();
        Axis two = facing.two();
        float width = box.getSize(one);
        if (width > (height = box.getSize(two))) {
            float subtracts = (width - height) / 2.0f;
            float marginSubstract = height / 4.0f;
            box.setMin(one, box.getMin(one) + subtracts + marginSubstract);
            box.setMax(one, box.getMax(one) - subtracts - marginSubstract);
            box.setMin(two, box.getMin(two) + marginSubstract);
            box.setMax(two, box.getMax(two) - marginSubstract);
        } else if (height > width) {
            float subtracts = (height - width) / 2.0f;
            float marginSubstract = width / 4.0f;
            box.setMin(two, box.getMin(two) + subtracts + marginSubstract);
            box.setMax(two, box.getMax(two) - subtracts - marginSubstract);
            box.setMin(one, box.getMin(one) + marginSubstract);
            box.setMax(one, box.getMax(one) - marginSubstract);
        }
        if (facing.positive) {
            box.setMax(facing.axis, parent.getMax(facing.axis) + (tile.caps.projects() ? -0.001f : 0.001f));
        } else {
            box.setMin(facing.axis, parent.getMin(facing.axis) - (tile.caps.projects() ? -0.001f : 0.001f));
        }
        return box;
    }
}

